function make_html(p)

eta=p.eta;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% make sure all images are in the same file format
d = dir([p.plotdir '/cluster*.jpg']);

for i=1:length(eta)
    [path filename ext] = fileparts(d(i).name);
    files{i}=filename;
    p.level{1}{i}=filename;
end

for i=1:length(eta)
    p.output_file = [p.htmldir filesep p.level{1}{i}  '.html'];
    p.i=i;
    p.img = [d(i).name];
    
    [val indx]=sort(eta(i,:),'descend');
    p.indx=indx;
    p.val=val;
    
    insert_link2(p)
end


function insert_link2(p)

level=p.level;
fid=fopen(p.output_file,'wt');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% header

fprintf(fid,['<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN">\n']);
fprintf(fid,['<html>\n']);
fprintf(fid,['<head>\n']);
fprintf(fid,['<style type="text/css">\n']);
fprintf(fid,['body {\n']);
fprintf(fid,['background-color: #eeeeee }\n']);

fprintf(fid,['.table{\n']);
fprintf(fid,['background-color: #eeeeee;\n']);
fprintf(fid,['width: 100%\n']);
fprintf(fid,['top: 0px;\n']);
fprintf(fid,['left: 0px;\n']);
fprintf(fid,['spacing: 2px 2px 2px 2px;\n']);
fprintf(fid,['padding: 1px 1px 1px 1px;\n']);
fprintf(fid,['border-width: 0px 0px 0px 0px;\n']);
fprintf(fid,['font-size : 11px;\n']);
fprintf(fid,['font-family : Verdana, Tahoma, "Times New Roman", Arial, sans-serif;\n']);
fprintf(fid,['text-align: left;\n']);
fprintf(fid,['}\n']);

fprintf(fid,['a{\n']);
fprintf(fid,['font-size: 13px;\n']);
fprintf(fid,['color : blue;\n']);
fprintf(fid,['text-decoration : none;\n']);
fprintf(fid,['}\n']);


fprintf(fid,['</style>\n']);
fprintf(fid,['</head>\n']);

% outer table
%fprintf(fid,['<table border=2 class=table><tr valign=top>\n']);
fprintf(fid,['<table border=2 width=\" 100 %%\"><tr valign=top>\n']);

fprintf(fid,['<td>\n']);
fprintf(fid,['<table class=table border=0>\n']);
for i=1:length(level{1})
    link = [  level{1}{i} '.html'];
    
    if p.i==i
        color = '<font color=\"red\">';
    else
        color='';
    end
    
    fprintf(fid,['<tr><td>\n']);
    fprintf(fid,['<a href=\"' link '\">' color p.level{1}{i}(end-1:end) '</a>\n']);
    
    if (i==23)
        fprintf(fid,['</table>\n']);
        fprintf(fid,['<td>\n']);
        fprintf(fid,['<table class=table border=0>\n']);
        
    end
end
fprintf(fid,['</table>\n']);
fprintf(fid,['<td>\n']);

tmp=find(p.indx==p.i); %find the indx for the cluster
p.img2=p.img;
fprintf(fid,['<table class=table ><tr><td>']);
fprintf(fid,['<center>Community ' num2str(p.indx(tmp)) ', eta(' num2str(p.indx(tmp)) ',' num2str(p.indx(tmp)) ')=<b>' num2str(p.val(tmp),'%4.3f') ]);
fprintf(fid,['<tr><td><img width=' num2str(p.img_width) ' src=\"../plot/'  p.img2 '\"><img width=120 src=\"../plot/string_'  p.img2 '\">\n']);
fprintf(fid,['</table>']);

fprintf(fid,['<td>\n']);
fprintf(fid,['<table class=table><tr>' ]);
count=1;

p.val (find(p.indx==p.i))=[];
p.indx(find(p.indx==p.i))=[]; % delete current cluster from list and plot 4 most connected clusters

for tmp=1:4    
    p.img2=p.img;
    fprintf(fid,['<td>\n']);
    fprintf(fid,['<table class=table><tr><td>' ]);
    p.img2(end-5:end-4)=myint2str(p.indx(tmp));
    fprintf(fid,[ '<center>Community ' num2str(p.indx(tmp)) ', eta(' num2str(p.i) ',' num2str(p.indx(tmp)) ')=<b>' num2str(p.val(tmp),'%4.3f') ]);
    fprintf(fid,['<tr><td><a href=\"cluster_' myint2str(p.indx(tmp)) '.html\"><img width=' num2str(p.img_width/2) ' src=\"../plot/'  p.img2 '\"></a>\n']);
    %fprintf(fid,['<tr><td><a href=\"cluster_' myint2str(p.indx(tmp)) '.html\"><img width=' num2str(p.img_width/2) ' src=\"../plot/string_'  p.img2 '\"></a>\n']);
    fprintf(fid,['</table>' ]);
    if tmp==2
        fprintf(fid,['<tr>\n']);
    end    
end
fprintf(fid,['</table>']);
fprintf(fid,['</table>\n']);
fclose(fid);

