function run_everything(p)

% This script will:
%  1. Make all necessary output directories
%  2. Make subject correlation matrices (if not exist already)
%  3. Read and threshold correlation matrices to get adjacency matrices
%  4. Run model inference for the specified models
%  5. 
%
% input:
%  p.projectname, name for the project
%  p.prefix, prefix of data filenames (e.g. 'swf')
%  p.extension, extension of data filenames (e.g. 'nii')
%  p.datapth, path to the subject subdirectories
%  p.roipth, path to ROI images 
%  p.outputroot, path to where output will be written
%  p.sameEta, assume same link probability matrix (eta) across subjects
%  p.plotting, will generate plots of output
%  p.density, density for the graphs
%  p.n_iter, number of iterations to run inference 
%  p.mm, vector of models to run (1=IRM, 2=IDM, 3=IHW, 4=BCD) (e.g. [1 4])
%
% Written by: Kasper Winther Andersen, 2013


%--------------------------------------------------------------------------
% change here
% only grap subjects with this prefix. Leave empty ('') if you want all subjects
subject_prefix=''; 
%--------------------------------------------------------------------------

% number of inference re-starts
num_runs=1;

opts.maxiter=p.n_iter;  % maximal number of iterations
opts.dens=p.density;    % graph density
opts.doplot=p.plotting; % plotting
opts.sameEta=p.sameEta; % sameEta across subjects
opts.mm=p.mm;           % models to run
    
%--------------------------------------------------------------------------
%--------------------------------------------------------------------------
%--------------------------------------------------------------------------

% make the project directory if not exist
projectroot=[p.outputroot filesep p.projectname];
if ~exist(projectroot)
    mkdir(projectroot)
end

% make directory for all the correlations
opts.corrpth=[projectroot filesep 'corrs'];
if ~exist(opts.corrpth)
    mkdir(opts.corrpth)
end

%--------------------------------------------------------------------------
% gather files
subs=dir([p.datapth filesep subject_prefix '*']);
tmp=subs;
to_del=[];
for i=1:length(tmp);
    if tmp(i).name(1)=='.',
        to_del=[to_del i]
    end
end
subs(to_del)=[];
disp(['Found ' num2str(length(subs)) ' subjects']);
%--------------------------------------------------------------------------

%--------------------------------------------------------------------------
% generate correlation matrices if not exist
for i=1:length(subs)
    pth=[p.datapth filesep subs(i).name filesep];
    d=dir([pth p.prefix '*.' p.extension]);
    data=[repmat(pth,length(d),1) char(d.name)];  
    outfile = [opts.corrpth filesep subs(i).name '_' p.prefix '.mat'];
    if ~exist(outfile)
        disp(['Calculating correlation matrix for ' subs(i).name])
        calc_correlations(p.roipth, data, outfile)
    else
        disp(['Correlations matrix exist for ' subs(i).name])
    end    
end
%--------------------------------------------------------------------------

%--------------------------------------------------------------------------
% read all correlation matrices from directory and threshold to get
% adjacency matrices
disp(['Tresholding at ' num2str(opts.dens) ' percent.']);
d=dir([opts.corrpth filesep subject_prefix '*.mat']);

sub_iter=1;
for i=1:length(d)    
    load([opts.corrpth filesep d(i).name]);
    a1tmp = to_mat(cm, 1-opts.dens/100);
    A{sub_iter}=sparse(a1tmp);    
    sub_iter = sub_iter+1;
end
opts.A=A;
%--------------------------------------------------------------------------

%--------------------------------------------------------------------------
% run inference
disp(['Start model inference.']);
for iter=1:num_runs    
    opts.roifiles=roifiles;
    opts.projectroot=projectroot;
    opts.prefix=['dens_' myint2str(opts.dens) '_iter_' myint2str(iter)];
    opts.subs=length(subs);
    p=run_inference(opts);
end
disp(['Done.']);
%--------------------------------------------------------------------------

