function p=run_inference(opts)

% Written by: Kasper Winther Andersen, 2013

% some parameters, which can be changed
opts.init_sample_iter=0;
noc=50;
dZstep=25;
rho0p=[1 1]; % flat beta prior
rho0n=[1 1];

% set the random seed
% RandStream.setDefaultStream(RandStream('mt19937ar','seed',sum(100*clock)));
rand('state',sum(100*clock));

W=createValidationData(opts.A, 0, 'UnDirected');


for m=opts.mm
    if m<4
        opts.dZstep=dZstep; 
        opts.nsampleiter=opts.maxiter;
        if m==1
            opts.method='IRM';
            method='IRM';
        elseif m==2
            opts.method='IDM';
            method='IDM';
        elseif m==3
            opts.method='IHW';
            method='IHW';
        end
        [L,cpu_time,Z,eta,sample,West] = IRMUnipartite(opts.A,W,noc,opts);
    else
        opts.dSstep=dZstep;        
        opts.nsampleiter=opts.maxiter;
        
        if isfield(opts,'method')
            opts=rmfield(opts,'method');
        end
        method='BCD';
        opts.rho0p=rho0p;
        opts.rho0n=rho0n;
        [L,cpu_time,Z,eta,gap,sample,West,predL]=BayesianCommunityDetection(opts.A,W,noc,opts);
    end
    p.samplefile = [opts.projectroot filesep method '_' opts.prefix filesep opts.prefix '_dens_' num2str(opts.dens) '_' method '.mat'];
    
    p.outputdir=[opts.projectroot filesep method '_' opts.prefix ];
    if ~exist(p.outputdir)
        mkdir(p.outputdir)
    end
    
    p.roifiles=opts.roifiles;
    p.A=opts.A;    
    p.sample=sample;
    save(p.samplefile,'-V7.3')
    if opts.doplot; 
        plot_Z_aal(p);
    end   
end

